/****** Object:  Table [dbo].[BufferTrace]    Script Date: 09/12/2013 23:45:55 ******/
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BufferTrace]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[BufferTrace](
	[TraceId] [bigint] IDENTITY(1,1) NOT NULL,
	[ApplicationName] nvarchar(128) NOT NULL,
	[Info] [varchar](max) NULL,
	[StartDate] [datetime] NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[RequestedCases] [int] NOT NULL,
	[DialingMask] [int] NOT NULL,
	[ClearBuffer] [bit] NOT NULL,
	[GroupNbr] [int] NOT NULL,
	[RoleSets] [varchar](max) NULL,
	[UseSmoothing] [bit] NOT NULL,
	[UseQuotas] [bit] NOT NULL,
	[Replicate] [bit] NOT NULL,
	[DNCFlag] [bit] NOT NULL,
	[FreshPriority] [int] NOT NULL,
	[WeightsCount] [int] NOT NULL,
	[ExcludedCases] [bigint] NOT NULL,
	[HalfOpenExcess] [int] NOT NULL,
	[TotalExtractedCases] [int] NOT NULL,
	[ClientHostname] nvarchar(128) NOT NULL CONSTRAINT DF_BufferTrace_ClientHostname DEFAULT '',
CONSTRAINT [PK_BufferTrace] PRIMARY KEY CLUSTERED 
(
	[TraceId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
ELSE
BEGIN
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'ClientHostname' AND object_id = OBJECT_ID(N'BufferTrace'))
  ALTER TABLE BufferTrace ADD [ClientHostname] nvarchar(128) NOT NULL CONSTRAINT DF_BufferTrace_ClientHostname DEFAULT ''
END
GO

---  
---  SP_NEW START
---
---Modified 2010-03-24: ReAdded the Location='Server' filter 
---Modified 2010-07-02: Enabled the pronto option :  Use Do Not Call list
---Modified 2010-12-01: Performance using tempdb
---Modified 2011-07-20: Added dialing mode. Renamed
---Modified 2011-11-18: Support for TimeSlot Counters
---Modified 2011-12-15: Weight applies to Callbacks
---Modified 2012-01-12: RoleSets
---Modified 2012-07-09: Change the nature of ResTimeSlot
---Modified 2012-09-18: Exclude assigned cases when in Role mode
---Modified 2012-11-02: Fix for Half opened
---Modified 2013-04-22: Fix for Half opened (2)
---Modified 2013-07-11: Fix for blocking of extraction in ServNo
---Modified 2013-09-13: Added Tracing
---Modified 2013-10-28: Added Tracing info; Performance modification for #excludedRespondent
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_FillCaseBuffer]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[VX_sp_FillCaseBuffer]
GO

CREATE PROCEDURE  [dbo].[VX_sp_FillCaseBuffer]  
	@BrowseNbr int = 100, -- Should use f(NbrLoggedAgents)
	@ProjectId int = 0, -- Normally ignored
	@DialingMask int = 0xFF, -- Bit: NA,NA,NA,NA,NA,PV,NP,PR 
	@ClearBuffer bit = 1, -- 1 -> clear and fill; 0 -> append to buffer
	@GroupNbr int = 0 , -- Default 0, ignored for project Roles
	@RoleSets varchar(max) = null, -- '1,2,3;1,4;1,2,4' ',' -> seperates roles, ';' seperates roleset belonging to same group/agent
	@TraceInfo varchar(max) = null,
	@TraceId bigint = null OUT
AS
	-- version Sept 2013
	DECLARE @RequestedCases int, @ExcludedCases bigint, @HalfOpenExcess int, @TotalExtractedCases int
	SET @RequestedCases = @BrowseNbr;

	DECLARE @StartTStamp DateTime
	SET @StartTStamp = getutcdate();

	DECLARE @isPreviewSupported bit
	SET @isPreviewSupported = (@DialingMask & 0x4) --3rd bit from right says module does Preview dial

	--Get configuration information
	DECLARE @UseSmoothing bit
	SET @UseSmoothing= (SELECT TOP 1 INSVALUE FROM Installation WHERE INSSECTION='QUOTAS' and INSIDENT='QUOTASSMOOTH')
	IF (@UseSmoothing IS NULL) SET @UseSmoothing=0
	
	DECLARE @UseQuotas bit
	SET @UseQuotas = (SELECT TOP 1 INSVALUE FROM Installation  WHERE INSSECTION='QUOTAS' and INSIDENT='QUOTASACTIFS')
	IF (@UseQuotas is NULL) SET @UseQuotas = 0

	DECLARE @Replicate bit
	SET @Replicate = (SELECT TOP 1 coalesce(INSVALUE,0) From Installation  Where INSSECTION='QUOTAS' and INSIDENT='QUOTASMODEREPLICATE')
	IF (@Replicate is NULL) SET @Replicate = 0
	
	DECLARE @dncFlag bit
	SET @dncFlag= (Select top 1 insvalue From Installation where INSSECTION='OPTIONS' and INSIDENT='DNC')
	IF (@dncFlag IS NULL) SET @dncFlag = 1
	
	DECLARE @FreshPriority int
	SET @FreshPriority = (Select top 1 INSVALUE From Installation where INSSECTION='RULES' and INSIDENT='PRIORITY OF FRESH')
	IF (@FreshPriority IS NULL) SET @FreshPriority = 0

	--Clear previous case buffer for group
	IF @ClearBuffer = 1 DELETE FROM dbo.BufferNew WHERE intgroup = @GroupNbr

	--Disable tracing
	SET NOCOUNT ON

	--Compile TimeSlots hit by each TimeZones   
	CREATE TABLE #tzts (timezone int,timeslot int)
	INSERT INTO #tzts
	SELECT id+0 as timezone,dbo.TimeSlotNumber(DateAdd(mi,(gmtbias + dstbias*dstactive)*60,GetUTCDATE())) as timeslot
	FROM dbo.TimeZones
	UNION SELECT 0,dbo.TimeSlotNumber(GetUTCDate())

	--Compile list of invalid respondent (timeslot limit reached, closed stratum)
	CREATE TABLE #excludedRespondent(respondent varchar(10) primary key) -- List of respondent invalid (TimeSlot / Closed Quotas)
	INSERT INTO #excludedRespondent
	SELECT ResRespondent -- Add respondent that are hit by the current TimeSlot
	FROM Respondent with(nolock)
		inner join TimeSlotHit with(nolock) on TimeSlotHit.TshRespondent = Respondent.ResRespondent
		inner join #tzts on #tzts.timeslot = TimeSlotHit.TshTimeSlot and #tzts.timezone = Respondent.ResTimeZone 
		inner join TimeSlot with(nolock) on TimeSlotHit.TshTimeSlot = TimeSlot.TslNumber
		left join TimeSlotCounter with(nolock) on TimeSlot.TslNumber = TimeSlotCounter.TslNumber and Respondent.IntLevel = TimeSlotCounter.RespondentLevel
	WHERE ResTimeSlot <> 0 
		and TimeSlotHit.[Counter] >= isnull(TimeSlotCounter.MaxCounter, TimeSlot.MaxCounter) -- Only exlude respondent whose reached the max for the timeslot
	UNION -- UNION instead of UNION ALL for better performance filtering the BufferNew inserts
	SELECT StrRespondent -- Add respondent that are part of a closed quota
	FROM Stratum with(nolock)
		inner join Quota with(nolock) on QtStratum = StrStratum
	WHERE QtStatusTemp = 2 -- Closed strata
	SET @ExcludedCases = @@RowCount --May include double counting
	
	--ReEnable tracing
	SET NOCOUNT OFF

	--Get stratum information
	DECLARE @NbrWeights int-- Number of Stratum with Weights
	SET @NbrWeights = 0
	if @Replicate <> 1 -- Weights and Replicates are not compatible : ignore the weights
		SELECT @NbrWeights = Count(QtStratum) FROM Quota with(nolock) 
		WHERE QtWeight >0 and QtStatusTemp<>2 AND QtUnused > 0 and (QtGroup=@GroupNbr or QtGroup=0)
	
	DECLARE @SumRemaining int
	SET @SumRemaining = 0	
	if @UseSmoothing = 1
		SELECT @SumRemaining = SUM(QtQuota - QtFrequence) FROM Quota with(nolock)
		WHERE QtStratum <> 0 and (qtgroup=@GroupNbr or qtGroup=0) and QtWeight <> 0 and QtQuota > 0 and QtStatus < 2

	--Get Project mode (GROUP or ROLESET)
	IF NOT EXISTS (SELECT 1 FROM tblPages WHERE kind = 12000 and name = 'SAMPLEASSIGNMENTMODE' and StaticValue = 'ROLE'	and k_id = 
		(SELECT k_id FROM tblPages WHERE Kind = 12000 and Name = 'InterviewerProjectId' and ('Voxco_Project_' + StaticValue = DB_NAME())))
	BEGIN --Group mode
	
		--Evaluate group string
		DECLARE @StrGroup char(3)
		SET @StrGroup = 'G' + right('0'+ convert(varchar(2),@groupnbr),2) --35% faster than with a if + length

		if @replicate = 0 
		begin
			if @NbrWeights = 0 
			begin

				-- general : no weights - no replicates
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM Respondent Res with(nolock)
				WHERE 
					/*Invariable criterion (should be same for every query in this SP */
					(ResBlocked = 0 or RestrictionOverride = 1) and (Res.Location = 'Server') and (ResActive = 1)
					and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
					and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
					and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)))
					and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
					and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
					and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
					-- Role not evaluated
					/*Variable criterion*/
					and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
				ORDER BY ResPriority desc, (case when rescallbackdate < '1901-01-01' then  '9999-12-31' else ResCallbackDate end), ResSeed
				SET @TotalExtractedCases = @@RowCount

			end
			else if @UseSmoothing = 0
			begin
      
				-- weight distribution without smoothing
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM (SELECT TOP (@BrowseNbr) ResRespondent, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, Res.DialingMode,
						case when Qt.QtWeight <> 0 then 1 else 0 end Weighted,
						ceiling((row_number() over (partition by qtquotaid order by (case when rescallbackdate < '1901-01-01' then  '9999-12-31' else ResCallbackDate end), Res.ResSeed)) 
							* (case when qtweight <> 0 then 1/qtweight else 1 end)) Ranking,
						abs(cast(binary_checksum(newid())as int)) * qtweight Position 
					FROM Respondent Res with(nolock)
						left join Stratum with(nolock) on resrespondent = strrespondent
						left join Quota Qt with(nolock) on strquotaid = qtquotaid
					WHERE 
						/*Invariable criterion (should be same for every query in this SP */
						(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
						and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
						and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
						and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)))
						and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
						and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
						and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
						-- Role not evaluated
						/*Variable criterion*/
						and ISNULL(Qt.QtStatusTemp,0) <> 2 and (ISNULL(QtGroup,0) in (@GroupNbr, 0))
						and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
					ORDER BY --Must sort out the cases exceeding their quota for half open and filter(post) them out
						Weighted desc, --Weighted stratum first, but we may run out
						Res.RestrictionOverride desc, Res.ResPriority desc, 
						--Above criterion are more important,  and if they steal from Weighted Stratum, they will be missing later and so it will balance
						Ranking, --Rank by CallBackdate & Seed and Weight over Quota partition
						Position --Randomly distributes the items of same rank according to weight
						) Res        
				GROUP BY ResRespondent, ResCallbackDate, ResPriority, ResSeed, ResPhone, DialingMode --Prevent duplicates from multiple Stratum
				ORDER BY max(Weighted) desc, ResPriority desc, min(Ranking), min(Position)     
				SET @TotalExtractedCases = @@RowCount
			
			end
			else --if @UseSmoothing = 1
			begin

				-- smoothing weight distribution
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM (SELECT TOP (@BrowseNbr) ResRespondent, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, Res.DialingMode,
						case when Qt.QtWeight <> 0 then 1 else 0 end Weighted,
						ceiling((row_number() over (partition by qtquotaid order by (case when rescallbackdate < '1901-01-01' then  '9999-12-31' else ResCallbackDate end), Res.ResSeed)) 
							* (case when qtweight <> 0 then 1/qtweight else 1 end)) Ranking,
						abs(cast(binary_checksum(newid())as int)) * qtweight Position 
					FROM Respondent Res with(nolock)
						left join stratum with(nolock) on resrespondent = strrespondent
						left join Quota Qt with(nolock) on strquotaid = qtquotaid
					WHERE 
						/*Invariable criterion (should be same for every query in this SP */
						(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
						and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
						and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
						and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)))
						and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
						and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
						and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
						-- Role not evaluated
						/*Variable criterion*/
						and ISNULL(Qt.QtStatusTemp,0) <> 2 and (ISNULL(QtGroup,0) in (@GroupNbr, 0))
						and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
					ORDER BY --!!!Must sort out the cases exceeding their quota for half open and filter(post) them out
						Weighted desc, --Weighted stratum first, but we may run out
						Res.RestrictionOverride desc, Res.ResPriority desc, 
						--Above criterion are more important,  and if they steal from Weighted Stratum, they will be missing later and so it will balance
						Ranking, --Rank by CallBackdate & Seed and Weight over Quota partition
						Position --Randomly distributes the items of same rank according to weight
						) Res        
				GROUP BY ResRespondent, ResCallbackDate, ResPriority, ResSeed, ResPhone, DialingMode --Prevent duplicates from multiple Stratum
				ORDER BY max(Weighted) desc, ResPriority desc, min(Ranking), min(Position)     
				SET @TotalExtractedCases = @@RowCount
      
			end	
		end
		else --if @replicate = 1
		begin

			-- replicates
			-- 1: call-backs with high priority - regardless of statustemp
			INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
			SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
			FROM Respondent Res with(nolock)
			WHERE
				/*Invariable criterion (should be same for every query in this SP */
				(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
				and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
				and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
				and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent))) --Allow call to respondent in maxed timeslot or closed strata
				and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
				and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
				and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
				-- Role not evaluated
				/*Variable criterion*/
				and ((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
				and	(resPriority >= @FreshPriority)
			ORDER BY ResPriority desc, rescallbackdate, ResSeed
			SET @TotalExtractedCases = @@RowCount
		
			SET @BrowseNbr = @BrowseNbr - (SELECT count(*) FROM dbo.BufferNew WHERE IntGroup=@GroupNbr)
		
			if @BrowseNbr > 0 
			begin
				-- 2 : fresh cases -- one at a time for replicates with statustemp <> 2
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM Respondent Res with(nolock)
				WHERE
					/*Invariable criterion (should be same for every query in this SP */
					(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
					and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
					and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
					and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent))) --Allow call to respondent in maxed timeslot or closed strata
					and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
					and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
					and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
					-- Role not evaluated
					/*Variable criterion*/
					and (ResCall=0) and (resPriority>= @freshPriority )
				ORDER BY ResPriority desc, ResSeed
				SET @TotalExtractedCases = @TotalExtractedCases + @@RowCount

			end
	     
			SET @BrowseNbr = @BrowseNbr - (SELECT count(*) FROM dbo.BufferNew WHERE IntGroup=@GroupNbr)
		
			if @BrowseNbr > 0 
			begin
				-- 3 : call-backs with low priority - regardless of statusTemp
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM Respondent Res with(nolock)
				WHERE
					/*Invariable criterion (should be same for every query in this SP */
					(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
					and ((ResIntervCall = @StrGroup) or ((@StrGroup = 'G00') and ((ResIntervCall = '***') or (RTrim(ResIntervCall) = '')))) --Must be assigned to all or requested group
					and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
					and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent))) --Allow call to respondent in maxed timeslot or closed strata
					and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
					and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
					and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
					-- Role not evaluated
					/*Variable criterion*/
					and ((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
					and	(resPriority < @freshPriority)
				ORDER BY ResPriority desc, rescallbackdate, ResSeed
				SET @TotalExtractedCases = @TotalExtractedCases + @@RowCount
			end
		end

	END ELSE BEGIN --Role mode
			
		-- Split supported roles
		SELECT RoleSet.Value RoleSet, convert(int, [Role].Value) [Role]
		INTO #SupportedRole
		FROM fn_cte_splitstring(@RoleSets, ';') RoleSet
			cross apply fn_cte_splitstring(RoleSet.Value, ',') [Role]

		if @replicate = 0 
		begin
			if @NbrWeights = 0 
			begin

				-- general : no weights - no replicates
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM Respondent Res with(nolock)
				WHERE 
					/*Invariable criterion (should be same for every query in this SP */
					(ResBlocked = 0 or RestrictionOverride = 1) and (Res.Location = 'Server') and (ResActive = 1)
					and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
					and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
					and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)))
					and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
					and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
					and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
					and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
						or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
							(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
							(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
					/*Variable criterion*/
					and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
				ORDER BY ResPriority desc, (case when rescallbackdate < '1901-01-01' then  '9999-12-31' else ResCallbackDate end), ResSeed
				SET @TotalExtractedCases = @@RowCount
	      
			end
			else if @UseSmoothing = 0
			begin
      
				-- weight distribution without smoothing
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM (SELECT TOP (@BrowseNbr) ResRespondent, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, Res.DialingMode,
						case when Qt.QtWeight <> 0 then 1 else 0 end Weighted,
						ceiling((row_number() over (partition by qtquotaid order by (case when rescallbackdate < '1901-01-01' then  '9999-12-31' else ResCallbackDate end), Res.ResSeed)) 
							* (case when qtweight <> 0 then 1/qtweight else 1 end)) Ranking,
						abs(cast(binary_checksum(newid())as int)) * qtweight Position 
					FROM Respondent Res with(nolock)
						left join Stratum with(nolock) on resrespondent = strrespondent
						left join Quota Qt with(nolock) on strquotaid = qtquotaid
					WHERE 
						/*Invariable criterion (should be same for every query in this SP */
						(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
						and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
						and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
						and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)))
						and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
						and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
						and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
						and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
							or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
								(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
								(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
						/*Variable criterion*/
						and ISNULL(Qt.QtStatusTemp,0) <> 2 and (ISNULL(QtGroup,0) in (@GroupNbr, 0))
						and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
					ORDER BY --Must sort out the cases exceeding their quota for half open and filter(post) them out
						Weighted desc, --Weighted stratum first, but we may run out
						Res.RestrictionOverride desc, Res.ResPriority desc, 
						--Above criterion are more important,  and if they steal from Weighted Stratum, they will be missing later and so it will balance
						Ranking, --Rank by CallBackdate & Seed and Weight over Quota partition
						Position --Randomly distributes the items of same rank according to weight
						) Res        
				GROUP BY ResRespondent, ResCallbackDate, ResPriority, ResSeed, ResPhone, DialingMode --Prevent duplicates from multiple Stratum
				ORDER BY max(Weighted) desc, ResPriority desc, min(Ranking), min(Position)     
				SET @TotalExtractedCases = @@RowCount

			end
			else --if @UseSmoothing = 1
			begin

				-- smoothing weight distribution
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM (SELECT TOP (@BrowseNbr) ResRespondent, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, Res.DialingMode,
						case when Qt.QtWeight <> 0 then 1 else 0 end Weighted,
						ceiling((row_number() over (partition by qtquotaid order by (case when rescallbackdate < '1901-01-01' then  '9999-12-31' else ResCallbackDate end), Res.ResSeed)) 
							* (case when qtweight <> 0 then 1/qtweight else 1 end)) Ranking,
						abs(cast(binary_checksum(newid())as int)) * qtweight Position 
					FROM Respondent Res with(nolock)
						left join stratum with(nolock) on resrespondent = strrespondent
						left join Quota Qt with(nolock) on strquotaid = qtquotaid
					WHERE 
						/*Invariable criterion (should be same for every query in this SP */
						(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
						and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
						and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
						and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent)))
						and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
						and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
						and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
						and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
							or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
								(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
								(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
						/*Variable criterion*/
						and ISNULL(Qt.QtStatusTemp,0) <> 2 and (ISNULL(QtGroup,0) in (@GroupNbr, 0))
						and ((Res.ResCall=0) or ((ResCallbackDate>0) and (ResCallbackDate<GetUTCDate()))) --Fresh or due Callbacks
					ORDER BY --!!!Must sort out the cases exceeding their quota for half open and filter(post) them out
						Weighted desc, --Weighted stratum first, but we may run out
						Res.RestrictionOverride desc, Res.ResPriority desc, 
						--Above criterion are more important,  and if they steal from Weighted Stratum, they will be missing later and so it will balance
						Ranking, --Rank by CallBackdate & Seed and Weight over Quota partition
						Position --Randomly distributes the items of same rank according to weight
						) Res        
				GROUP BY ResRespondent, ResCallbackDate, ResPriority, ResSeed, ResPhone, DialingMode --Prevent duplicates from multiple Stratum
				ORDER BY max(Weighted) desc, ResPriority desc, min(Ranking), min(Position)     
				SET @TotalExtractedCases = @@RowCount
      
			end	
		end
		else --if @replicate = 1
		begin

			-- replicates
			-- 1: call-backs with high priority - regardless of statustemp
			INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
			SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
			FROM Respondent Res with(nolock)
			WHERE
				/*Invariable criterion (should be same for every query in this SP */
				(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
				and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
				and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
				and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent))) --Allow call to respondent in maxed timeslot or closed strata
				and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
				and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
				and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
				and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
					or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
						(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
						(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
				/*Variable criterion*/
				and ((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
				and	(resPriority >= @FreshPriority)
			ORDER BY ResPriority desc, rescallbackdate, ResSeed
			SET @TotalExtractedCases = @@RowCount
		
			SET @BrowseNbr = @BrowseNbr - (SELECT count(*) FROM dbo.BufferNew WHERE IntGroup=@GroupNbr)
		
			if @BrowseNbr > 0 
			begin
				-- 2 : fresh cases -- one at a time for replicates with statustemp <> 2
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM Respondent Res with(nolock)
				WHERE
					/*Invariable criterion (should be same for every query in this SP */
					(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
					and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
					and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
					and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent))) --Allow call to respondent in maxed timeslot or closed strata
					and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
					and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
					and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
					and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
						or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
							(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
							(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
					/*Variable criterion*/
					and (ResCall=0) and (resPriority>= @freshPriority )
				ORDER BY ResPriority desc, ResSeed
				SET @TotalExtractedCases = @TotalExtractedCases + @@RowCount
			end
	     
			SET @BrowseNbr = @BrowseNbr - (SELECT count(*) FROM dbo.BufferNew WHERE IntGroup=@GroupNbr)
		
			if @BrowseNbr > 0 
			begin
				-- 3 : call-backs with low priority - regardless of statusTemp
				INSERT INTO BufferNew (Respondent, intgroup, CallbackDate, [Priority], seed, Phone, ProjectId, DialingMode)
				SELECT TOP (@BrowseNbr) ResRespondent, @GroupNbr, ResCallbackDate, ResPriority, Res.ResSeed, ResPhone, @ProjectId, Res.DialingMode 
				FROM Respondent Res with(nolock)
				WHERE
					/*Invariable criterion (should be same for every query in this SP */
					(ResBlocked = 0 or RestrictionOverride = 1) and (Location = 'Server') and (ResActive = 1)
					and ((ResIntervCall = '***') or (ResIntervCall = '') or (RTrim(ResIntervCall) = '') or (ResIntervCall between 'G00' and 'G99')) --Must be assigned to all, groups ignored
					and (@isPreviewSupported = 1 or DialingMode = 0) -- Optimal performance: Assuming only [Default]=0 or [Preview]=3 are supported
					and (RestrictionOverride = 1 or (NOT EXISTS (SELECT 1 FROM #excludedRespondent where Respondent = ResRespondent))) --Allow call to respondent in maxed timeslot or closed strata
					and (@UseQuotas = 0 or RestrictionOverride = 0 or (NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaID = QtQuotaID WHERE QtQuota <> 0 and QtFrequence >= QtQuota and StrRespondent = ResRespondent)))
					and (NOT EXISTS (SELECT 1 FROM doNotCallList with(nolock) WHERE @dncFlag = 1 AND resphone=phone)) --Exclude DNC if active
					and (NOT EXISTS (SELECT 1 FROM BufferNew where Respondent = ResRespondent)) --Prevent double insert
					and ((NOT EXISTS (SELECT 1 FROM Stratum with(nolock) inner join Quota with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null)) --No roles required for respondent
						or (EXISTS (SELECT 1 FROM #SupportedRole RS WHERE NOT EXISTS -- Must have a roleset covering all roles required for respondent
							(SELECT 1 FROM Stratum with(nolock) inner join Quota ResRole with(nolock) on StrQuotaId = QtQuotaId WHERE StrRespondent = ResRespondent and RoleId is not null and NOT EXISTS --List of roles required for respondent
							(SELECT 1 FROM #SupportedRole RSR WHERE RS.RoleSet = RSR.RoleSet and ResRole.RoleId = RSR.[Role]))))) --List of role covered by RoleSet
					/*Variable criterion*/
					and ((ResCall=1) and (ResCallbackDate >0) and (ResCallbackDate< GetUTCDate()))
					and	(resPriority < @freshPriority)
				ORDER BY ResPriority desc, rescallbackdate, ResSeed
				SET @TotalExtractedCases = @TotalExtractedCases + @@RowCount
			end
		end

		DROP TABLE #SupportedRole
	END

	--Check if HalfOpen quotas exists
	if @Replicate <> 1 and EXISTS(
		SELECT 1 FROM QUOTA with(nolock) WHERE QtStatus = 1 and ( QtGroup=@GroupNbr or QtGroup=0) and QtQuota>0)

		-- Delete Respondent that exceeds HalfOpen Quotas
		DELETE FROM BufferNew
		WHERE EXISTS (
			SELECT Respondent
			FROM
				(SELECT Respondent Respondent,
					row_number() over (partition by QtQuotaId order by priority, callbackdate, seed) [rank],
					Qt.QtQuota - (QtFrequence + QtOnline) [max]
				FROM BufferNew 
					inner join Stratum with(nolock) on Respondent = StrRespondent
					inner join Quota Qt with(nolock) on StrQuotaId = Qt.QtQuotaId
				WHERE IntGroup = @GroupNbr
					and Qt.QtStatus = 1
					and Qt.QtQuota>0) res
			WHERE [rank] > [max] and res.respondent = BufferNew.Respondent)
		SET @HalfOpenExcess = @@RowCount
		SET @TotalExtractedCases = @TotalExtractedCases - @HalfOpenExcess
	
	DROP TABLE #tzts
	DROP TABLE #excludedRespondent


	--Write a trace of the extraction
	SET NOCOUNT ON
	DECLARE @InsertedTrace table(TraceId bigint)
	INSERT INTO BufferTrace(Info,StartDate,EndDate,ApplicationName,ClientHostname,
		RequestedCases,DialingMask,ClearBuffer,GroupNbr,RoleSets,
		UseSmoothing,UseQuotas,[Replicate],DNCFlag,FreshPriority,WeightsCount,
		ExcludedCases,HalfOpenExcess,TotalExtractedCases)
	OUTPUT inserted.TraceId INTO @InsertedTrace
	VALUES (@TraceInfo,@StartTStamp,getutcdate(),APP_NAME(),HOST_NAME(),
		@RequestedCases,@DialingMask,@ClearBuffer,@GroupNbr,@RoleSets,
		@UseSmoothing,@UseQuotas,@Replicate,@dncFlag,@FreshPriority,@NbrWeights,
		@ExcludedCases,@HalfOpenExcess,@TotalExtractedCases)
	SELECT @TraceId = TraceId FROM @InsertedTrace  
	SET NOCOUNT OFF
GO

/****** Object:  StoredProcedure [dbo].[sp_QuotasReindex]    Script Date: 11/22/2009 14:00:41 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_quotasreindex]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[Sp_quotasreindex]
GO
CREATE PROCEDURE [dbo].[Sp_quotasreindex]
                @ProjectId INT,
                @userId    INT
AS

/* Block dialing for cases that ARE NOT currently blocked and ARE found in any closed strata */

  UPDATE Respondent  
  SET    ResBlocked = 1,
         ProjectId = @ProjectId,
         ModifiedBy = @UserId,
         Modified = Getutcdate()
  WHERE  ResBlocked=0 AND
            EXISTS (SELECT 1
                           FROM   Quota q with(nolock) inner join Stratum s with(nolock) on q.QtQuotaId = s.StrQuotaId
                           WHERE  q.QtStatus = 2 and s.StrRespondent = ResRespondent)

/* Enable dialing for cases that ARE currently blocked and ARE NOT found in any closed strata */                                       

  UPDATE Respondent  
  SET    ResBlocked = 0,
         ProjectId = @ProjectId,
         ModifiedBy = @UserId,
         Modified = Getutcdate()
  WHERE  ResBlocked=1 AND
           Not EXISTS (SELECT 1
                           FROM   Quota q with(nolock) inner join Stratum s with(nolock) on q.QtQuotaid = s.StrQuotaId
                           WHERE  q.QtStatus = 2 and s.StrRespondent = ResRespondent)                           
GO

